/***************************************************************/
//
//
//		DirectX	[Wall.cpp]
//
//												Author	kazuki tanaka
//												Date	2016 05/30
/*---------------------------------------------------------------
Update : 2016/04/18
			bZ[W{bNX\
Update : 2016/04/25

/****************************************************************/


/****************************************************************/
//
//		wb_[t@C
//
/****************************************************************/
#include "main.h"
#include "wall.h"

/*---------------------------------------------------------------
	}N`
---------------------------------------------------------------*/

#define NUM_VERTEX (4)		// STRIP

#define NUM_Wall (2)

/*---------------------------------------------------------------
	萔`
---------------------------------------------------------------*/

// tB[hTCY̍\
typedef struct{

	D3DXVECTOR3 start;
	D3DXVECTOR3 angle;
	unsigned int height;
	unsigned int width;
	float size;

}Wall_SIZE;

/*---------------------------------------------------------------
	vg^Cv錾
---------------------------------------------------------------*/

void MakeVertexWall(LPDIRECT3DDEVICE9 pDevice);		// _̍쐬

/*----------------------------------------------------------------
	O[oϐ
----------------------------------------------------------------*/
//static VERTEX_3D g_aVertex[NUM_VERTEX];			// _

LPDIRECT3DTEXTURE9 g_pTextureWall=nullptr;			// eNX`-C^[tF-Xp

LPDIRECT3DVERTEXBUFFER9 g_pVtxBufferWall = nullptr;	// _obt@C^[tF[Xւ̃|C^
LPDIRECT3DINDEXBUFFER9 g_pIdxBufferWall  = nullptr;	// CfbNXobt@C^[tF[Xւ̃|C^

Wall_SIZE g_Wall;									// 



// |S̏
void InitWall( void )
{

	
	g_Wall.height = 3;
	g_Wall.width  = 3;
	g_Wall.size   = 10;
	g_Wall.start  = D3DXVECTOR3( -15, 30, 0 );  
	

	// foCX󂯎p֐
	LPDIRECT3DDEVICE9 g_pPD3DDevice = GetDevice( );

	MakeVertexWall(g_pPD3DDevice);

	// eNX`̓ǂݍ 
	if( FAILED( D3DXCreateTextureFromFile( g_pPD3DDevice, "data\\TEXTURE\\field.jpg", &g_pTextureWall )))
	{
		#ifdef _DEBUG
		MessageBox( NULL, "WalleNX`t@C̓ǂݍ݂Ɏs܂!" , "TEXTURE LOAD ERROR!!", MB_OK | MB_ICONWARNING );
		#endif	// _DEBUG
	}

	
}

// |S̏
void UninitWall( void )
{

	SAFE_RELEASE(g_pTextureWall)

	SAFE_RELEASE( g_pVtxBufferWall )

	SAFE_RELEASE( g_pIdxBufferWall )

}

// |S̍XV
void UpdateWall( void )
{

}

// |S̕`
void DrawWall( void )
{


	// foCX̎󂯎
	LPDIRECT3DDEVICE9 pDevice = GetDevice( );

	D3DXMATRIX mtxDefault;

	// Pʍsւ̏( sPʍsɂ )
	D3DXMatrixIdentity( &mtxDefault );

	// foCXɃ[hϊsݒ
	pDevice ->SetTransform( D3DTS_WORLD, &mtxDefault );

	// Xg[
	pDevice ->SetStreamSource( 0,
	g_pVtxBufferWall,								// Xg[ɃoCh钸_obt@
	0,												// Xg[擪璸_f[^擪܂ł̃ItZbg (oCgP)
	sizeof( VERTEX_3D ));							// ̃XgChl(oCgP)

	// _tH[}bg̐ݒ
	pDevice->SetFVF( FVF_VERTEX_3D );

	// CfbNXobt@̐ݒ
	pDevice ->SetIndices( g_pIdxBufferWall );

	// eNX`̐ݒ
	pDevice->SetTexture( 0, g_pTextureWall );
	
	// |S̕`
	//pDevice ->DrawPrimitive( D3DPT_TRIANGLESTRIP, 0, ((2+2*g_Wall.width)*g_Wall.height) + (g_Wall.height-1)*2 - 2 );
	pDevice ->DrawIndexedPrimitive( D3DPT_TRIANGLESTRIP, 0, 0, ((2 + 2 * g_Wall.width)*g_Wall.height + ( g_Wall.height - 1 )*2), 0, ((2 + 2 * g_Wall.width)*g_Wall.height + ( g_Wall.height - 1 )*2)-2 );


}

// _̍쐬
void MakeVertexWall( LPDIRECT3DDEVICE9 pDevice )
{


	VERTEX_3D *pVtx;											// zAhX
	WORD      *pIndex;											// zAhXCfbNX


	// _obt@̍쐬
	if( FAILED( pDevice ->CreateVertexBuffer(
			sizeof( VERTEX_3D ) * (( g_Wall.width + 1 )  * ( g_Wall.height + 1 )),			// mۂobt@TCY(_m) P:oCg
			D3DUSAGE_WRITEONLY,									// gp@
			FVF_VERTEX_3D,										// gp钸_tH[}bg
			D3DPOOL_MANAGED,									// obt@̊Ǘ@
			&g_pVtxBufferWall,									// i[|C^
			NULL )))
	{
		#ifdef _DEBUG
		MessageBox( NULL, "obt@ւ݂̏Ɏs܂!!" , " Wall VtxBuf ERROR !!" , MB_OK );
		#endif	// _DEBUG
		return;
	}


	// zAhX̎擾
	g_pVtxBufferWall -> Lock( 0, 0, (void**)&pVtx, 0 );

	//int index = 0;

	// _obt@̐ݒ

	// CREATE MESH Wall
	for( int y = 0,x = 0; y < g_Wall.height+1; y++ ){

		for( x = 0; x < g_Wall.width+1; x++ ){
		
			pVtx[ ((g_Wall.width+1))*y + (x) + 0 ].pos    = D3DXVECTOR3 ( g_Wall.start.x + ( g_Wall.size * x ), g_Wall.start.y - ( g_Wall.size * y), g_Wall.start.z );

			pVtx[ ((g_Wall.width+1))*y + (x) + 0 ].tex    = D3DXVECTOR2( (1.0f * x), (1.0f * y) );

			pVtx[ ((g_Wall.width+1))*y + (x) + 0 ].color  = D3DCOLOR_RGBA( 255, 255, 255, 255 );

			pVtx[ ((g_Wall.width+1))*y + (x) + 0 ].normal = D3DXVECTOR3( 0.0f, 0.0f, -1.0f );
		}
	}


	// obt@̃AbN
	g_pVtxBufferWall ->Unlock( );


	// CfbNXobt@̒`
	if( FAILED( pDevice ->CreateIndexBuffer(
		sizeof( WORD ) * ((2 + 2 * g_Wall.width)*g_Wall.height + ( g_Wall.height - 1 )*2),
		D3DUSAGE_WRITEONLY,
		D3DFMT_INDEX16,
		D3DPOOL_MANAGED,
		&g_pIdxBufferWall,
		NULL)))
	{
		#ifdef _DEBUG
		MessageBox( NULL, "Indexւ݂̏Ɏs܂!!", "Index Buffer ERROR !!", MB_OK | MB_ICONWARNING );
		#endif	// -> _DEBUG

		return;
	}


	// CfbNXbNzAhX擾
	g_pIdxBufferWall->Lock( 0, 0, (void**)&pIndex, 0 );


	// _W̐ݒ
	for( int y = 0,x = 0,alignNumber = 0,index = 0; y < g_Wall.height; y++ ){

		// kރ|S̍쐬
		if( y ){
				
			x = 0;
			pIndex[ ((g_Wall.width+1)*2)*y + (2*x) + 0 + alignNumber*2 ] = index - 1;
			pIndex[ ((g_Wall.width+1)*2)*y + (2*x) + 1 + alignNumber*2 ] = index + (g_Wall.width+1);
			alignNumber++;
		}

		for( x = 0; x < g_Wall.width+1; x++ ){

			pIndex[ ((g_Wall.width+1)*2)*y + (2*x) + 0 + alignNumber*2 ] = index + (g_Wall.width+1);
			pIndex[ ((g_Wall.width+1)*2)*y + (2*x) + 1 + alignNumber*2 ] = index;
			index++;
		}
	}



	// obt@̃AbN
	g_pIdxBufferWall ->Unlock( );

	return;

}

// MESHWall̍쐬
void CreateMeshWall( const D3DXVECTOR3 coord, const float length, const unsigned int WallNumber )
{


	// tB[h
	SAFE_RELEASE( g_pVtxBufferWall )
	SAFE_RELEASE( g_pIdxBufferWall )

	// tB[hݒ菈
	g_Wall.height = WallNumber;
	g_Wall.width  = WallNumber;
	g_Wall.size   = length;
	g_Wall.start  = coord;  

	{ // tB[h

		// foCX󂯎p֐
		LPDIRECT3DDEVICE9 pDevice = GetDevice( );

		MakeVertexWall( pDevice );

	} // -> END Wall SET


}

// MESHWall̍쐬
void CreateMeshWallCenter( const float length, const unsigned int WallNumber )
{


	// tB[h
	SAFE_RELEASE( g_pVtxBufferWall )
	SAFE_RELEASE( g_pIdxBufferWall )

	// SZo
	float harfdiamiter =  (float)((float)WallNumber * 0.5f) * length;

	// tB[hݒ菈
	g_Wall.height = WallNumber;
	g_Wall.width  = WallNumber;
	g_Wall.size   = length;
	g_Wall.start  = D3DXVECTOR3( -harfdiamiter, harfdiamiter*2, 0 );  

	{ // tB[h

		// foCX󂯎p֐
		LPDIRECT3DDEVICE9 g_pPD3DDevice = GetDevice( );

		MakeVertexWall(g_pPD3DDevice);

	}	// -> END Wall SET

}

// MESHWall̍쐬
void CreateMeshWallCenter( const int width, const int height, const float length )
{


	// tB[h
	SAFE_RELEASE( g_pVtxBufferWall )
	SAFE_RELEASE( g_pIdxBufferWall )

	// SZo
	float harfdiamiterX =  (float)((float)width * 0.5f) * length;
	float harfdiamiterZ =  (float)((float)height * 0.5f) * length;

	// tB[hݒ菈
	g_Wall.height = height;
	g_Wall.width  = width;
	g_Wall.size   = length;
	g_Wall.start  = D3DXVECTOR3( -harfdiamiterX, 0, harfdiamiterZ );  

	{ // tB[h

		// foCX󂯎p֐
		LPDIRECT3DDEVICE9 g_pPD3DDevice = GetDevice( );

		MakeVertexWall(g_pPD3DDevice);

	}	// -> END Wall SET

}




